/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.samples;

import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import jemu.ui.JEMU;

public enum Samples {
    UNREGISTERED("jemu/core/samples/wav/unregistered.wav"),
    GAMEBROWSER("jemu/core/samples/wav/gamebrowser.wav"),
    PAC_START("jemu/core/samples/wav/gs_start.wav"),
    PAC_EAT("jemu/core/samples/wav/gs_chomp.wav"),
    PAC_DIE("jemu/core/samples/wav/gs_pacmandies.wav"),
    PAC_EATGHOST("jemu/core/samples/wav/gs_eatghost.wav"),
    PAC_EATFRUIT("jemu/core/samples/wav/gs_eatfruit.wav"),
    PAC_TURNGHOST("jemu/core/samples/wav/gs_ghostblue.wav"),
    PAC_RETURNGHOST("jemu/core/samples/wav/gs_returnghost.wav"),
    PAC_SIREN("jemu/core/samples/wav/gs_siren_soft.wav"),
    PAC_ADDLIVE("jemu/core/samples/wav/gs_extrapac.wav"),
    BREAK("jemu/core/samples/wav/breakpoint.wav"),
    BREAKI("jemu/core/samples/wav/instruction.wav"),
    EJECT("jemu/core/samples/wav/eject.wav"),
    INSERT("jemu/core/samples/wav/insert.wav"),
    MOTOR("jemu/core/samples/wav/motor.wav"),
    MOTORWINCPC("jemu/core/samples/wav/motor_wincpc.wav"),
    SEEK("jemu/core/samples/wav/seek.wav"),
    SEEKWINCPC("jemu/core/samples/wav/seek_forward_long_wincpc.wav"),
    SEEKBACK("jemu/core/samples/wav/seekback.wav"),
    SEEKBACKWINCPC("jemu/core/samples/wav/seek_back_long_wincpc.wav"),
    TRACK("jemu/core/samples/wav/track.wav"),
    TRACKWINCPC("jemu/core/samples/wav/seek_forward_very_short_wincpc.wav"),
    TRACKBACK("jemu/core/samples/wav/trackback.wav"),
    TRACKBACKWINCPC("jemu/core/samples/wav/seek_backvery_short_wincpc.wav"),
    DEGAUSS("jemu/core/samples/wav/monitoron.wav"),
    RELAIS("jemu/core/samples/wav/relon.wav"),
    RELAISOFF("jemu/core/samples/wav/reloff.wav"),
    TAPEMOTOR("jemu/core/samples/wav/tapmotor.wav"),
    WINDMOTOR("jemu/core/samples/wav/wind.wav"),
    REWINDMOTOR("jemu/core/samples/wav/rewind.wav"),
    TAPEKEY("jemu/core/samples/wav/tapekey.wav"),
    TAPESTOP("jemu/core/samples/wav/tapestop.wav"),
    TAPEINSERT("jemu/core/samples/wav/tape_insert.wav"),
    PRINTER("jemu/core/samples/wav/printer.wav"),
    TAPEEJECT("jemu/core/samples/wav/tape_eject.wav"),
    KEYPRESS("jemu/core/samples/wav/cpckey_press.wav"),
    KEYRELEASE("jemu/core/samples/wav/cpckey_release.wav"),
    ENTERPRESS("jemu/core/samples/wav/cpcenter_press.wav"),
    ENTERRELEASE("jemu/core/samples/wav/cpcenter_release.wav"),
    SPACERELEASE("jemu/core/samples/wav/cpcspace_release.wav"),
    SPACEPRESS("jemu/core/samples/wav/cpcspace_press.wav"),
    KPRESS("jemu/core/samples/wav/464key_press.wav"),
    KRELEASE("jemu/core/samples/wav/464key_release.wav"),
    EPRESS("jemu/core/samples/wav/464enter_press.wav"),
    ERELEASE("jemu/core/samples/wav/464enter_release.wav"),
    SRELEASE("jemu/core/samples/wav/464space_release.wav"),
    SPRESS("jemu/core/samples/wav/464space_press.wav"),
    LOADING("jemu/core/samples/wav/loading.wav"),
    CORRUPT("jemu/core/samples/wav/corrupt.wav"),
    FIXTRACKS("jemu/core/samples/wav/diskfixer.wav"),
    SSA("jemu/core/samples/wav/ssa1.wav"),
    DKT("jemu/core/samples/wav/dktronics.wav"),
    FINISHED("jemu/core/samples/wav/finished.wav"),
    CORRUPTED("jemu/core/samples/wav/corrupted.wav"),
    NEEDLE1("jemu/core/samples/wav/needle1.wav"),
    NEEDLE2("jemu/core/samples/wav/needle2.wav"),
    NEEDLE3("jemu/core/samples/wav/needle3.wav"),
    NEEDLE4("jemu/core/samples/wav/needle1.wav"),
    NEEDLE5("jemu/core/samples/wav/needle2.wav"),
    NEEDLE6("jemu/core/samples/wav/needle3.wav"),
    NEEDLE7("jemu/core/samples/wav/needle1.wav"),
    NEEDLE8("jemu/core/samples/wav/needle2.wav"),
    NEEDLE11("jemu/core/samples/wav/needle1.wav"),
    NEEDLE21("jemu/core/samples/wav/needle2.wav"),
    NEEDLE31("jemu/core/samples/wav/needle3.wav"),
    NEEDLE41("jemu/core/samples/wav/needle1.wav"),
    NEEDLE51("jemu/core/samples/wav/needle2.wav"),
    NEEDLE61("jemu/core/samples/wav/needle3.wav"),
    NEEDLE71("jemu/core/samples/wav/needle1.wav"),
    NEEDLE81("jemu/core/samples/wav/needle2.wav"),
    NEEDLE12("jemu/core/samples/wav/needle1.wav"),
    NEEDLE22("jemu/core/samples/wav/needle2.wav"),
    NEEDLE32("jemu/core/samples/wav/needle3.wav"),
    NEEDLE42("jemu/core/samples/wav/needle1.wav"),
    NEEDLE52("jemu/core/samples/wav/needle2.wav"),
    NEEDLE62("jemu/core/samples/wav/needle3.wav"),
    NEEDLE72("jemu/core/samples/wav/needle1.wav"),
    NEEDLE82("jemu/core/samples/wav/needle2.wav"),
    NEEDLE13("jemu/core/samples/wav/needle1.wav"),
    NEEDLE23("jemu/core/samples/wav/needle2.wav"),
    NEEDLE33("jemu/core/samples/wav/needle3.wav"),
    NEEDLE43("jemu/core/samples/wav/needle1.wav"),
    NEEDLE53("jemu/core/samples/wav/needle2.wav"),
    NEEDLE63("jemu/core/samples/wav/needle3.wav"),
    NEEDLE73("jemu/core/samples/wav/needle1.wav"),
    NEEDLE83("jemu/core/samples/wav/needle2.wav"),
    NEEDLE14("jemu/core/samples/wav/needle1.wav"),
    NEEDLE24("jemu/core/samples/wav/needle2.wav"),
    NEEDLE34("jemu/core/samples/wav/needle3.wav"),
    NEEDLE44("jemu/core/samples/wav/needle1.wav"),
    NEEDLE54("jemu/core/samples/wav/needle2.wav"),
    NEEDLE64("jemu/core/samples/wav/needle3.wav"),
    NEEDLE74("jemu/core/samples/wav/needle1.wav"),
    NEEDLE84("jemu/core/samples/wav/needle2.wav"),
    NEEDLE15("jemu/core/samples/wav/needle1.wav"),
    NEEDLE25("jemu/core/samples/wav/needle2.wav"),
    NEEDLE35("jemu/core/samples/wav/needle3.wav"),
    NEEDLE45("jemu/core/samples/wav/needle1.wav"),
    NEEDLE55("jemu/core/samples/wav/needle2.wav"),
    NEEDLE65("jemu/core/samples/wav/needle3.wav"),
    NEEDLE75("jemu/core/samples/wav/needle1.wav"),
    NEEDLE85("jemu/core/samples/wav/needle2.wav"),
    NEEDLE16("jemu/core/samples/wav/needle1.wav"),
    NEEDLE26("jemu/core/samples/wav/needle2.wav"),
    NEEDLE36("jemu/core/samples/wav/needle3.wav"),
    NEEDLE46("jemu/core/samples/wav/needle1.wav"),
    NEEDLE56("jemu/core/samples/wav/needle2.wav"),
    NEEDLE66("jemu/core/samples/wav/needle3.wav"),
    NEEDLE76("jemu/core/samples/wav/needle1.wav"),
    NEEDLE86("jemu/core/samples/wav/needle2.wav"),
    CARRET("jemu/core/samples/wav/carret.wav"),
    OKAY("jemu/core/samples/wav/okay.wav");

    public boolean nosamples = false;
    public static Volume volume;
    private Clip clip;

    private Samples(String soundFileName) {
        boolean bl = this.nosamples = !JEMU.isWindows();
        if (this.nosamples) {
            return;
        }
        try {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(soundFileName);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(url);
            AudioFormat format = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(audioInputStream);
        }
        catch (Exception e) {
            this.nosamples = true;
        }
    }

    public void play() {
        if (this.nosamples) {
            return;
        }
        if (volume != Volume.MUTE) {
            if (this.clip.isRunning()) {
                this.clip.stop();
            }
            this.clip.setFramePosition(0);
            this.clip.start();
        }
    }

    public void loop() {
        if (this.nosamples) {
            return;
        }
        if (volume != Volume.MUTE) {
            if (this.clip.isRunning()) {
                this.clip.stop();
            }
            this.clip.setFramePosition(0);
            this.clip.loop(-1);
        }
    }

    public void loop2() {
        if (this.nosamples) {
            return;
        }
        if (volume != Volume.MUTE && !this.clip.isRunning()) {
            this.clip.setFramePosition(0);
            this.clip.loop(-1);
        }
    }

    public void stop() {
        if (this.nosamples) {
            return;
        }
        if (this.clip.isRunning()) {
            this.clip.stop();
        }
        this.clip.setFramePosition(0);
        this.clip.stop();
    }

    static void init() {
        Samples.values();
    }

    static {
        volume = Volume.HIGH;
    }

    public static enum Volume {
        MUTE,
        LOW,
        MEDIUM,
        HIGH;

    }
}

